// Listing 8.7. Przykad zastosowania funkcji dostpu do danych 
// powodujcego odizolowanie kodu klienta od nazw pl danych 
// hermetyzacja danych przy zastosowaniu funkcji usugowych - serwerw

#include <iostream> 
using namespace std;

struct Cylinder 		// struktura danych wymagajcych dostpu
{ 
  double radius, height; 
} ;

void enterData(Cylinder &c, char number[])
{ 
	cout << "Wprowad promie i wysoko  ";
	cout << number << " walca: ";  	// tu pojawia si zmienny numer walca
	cin >> c.radius >> c.height;  	// inicjujemy walec
}

void validateCylinder(Cylinder c)
{ 
  if (c.radius < 0) c.radius = 10; 	// domylne wartoci danych
  if (c.height < 0) c.height = 20; 
}

double getVolume(const Cylinder& c) 	// obliczanie objtoci
{ 
  return c.height * c.radius * c.radius * 3.141593; 
}

void scaleCylinder(Cylinder &c, double factor)
{ 
  c.radius *= factor;  			// skalowanie wymiarw
  c.height *= factor; 
}

void printCylinder(const Cylinder &c) 	// drukowanie stanu obiektu
{ 
  cout << "promie: " <<c.radius << " wysoko: " <<c.height <<endl; 
}

int main() 				// przekazanie odpowiedzialnoci funkcjom usugowym
{
Cylinder c1, c2; 			// dane dla programu
enterData(c1,"pierwszy"); 		// inicjowanie pierwszego walca
validateCylinder(c1); 			// wartoci domylne w razie nieprawidowych danych
enterData(c2,"drugi"); 			// inicjowanie drugiego walca
validateCylinder(c2); 			// wartoci domylne w razie nieprawidowych danych
if (getVolume(c1) < getVolume(c2)) 	// porwnanie objtoci
{ 
  scaleCylinder(c1,1.2); 		// powikszenie skali
  cout << "\nWymiary pierwszego walca po zmianie\n"; 	// wydruk wymiarw
  printCylinder(c1); 
}
else 					// jeli nie - tylko komunikat: BEZ ZMIAN
  cout << "Wymiary pierwszego walca - bez zmian." << endl;
return 0;
}
